package io.better.toutiao.api;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * The interface Advertiser api.
 *
 * @author better create in 2019-04-27 10:47
 */
@FeignClient(name = "${toutiao.api.advertiser-url}", url = "/advertiser")
public interface AdvertiserApi {

    /**
     * 获取广告主信息
     *
     * @param accessToken   accessToken
     * @param advertiserIds 广告主ID数组
     * @param fields        字段数组
     * @return the advertiser info
     */
    @GetMapping(value = "/info")
    List<Map<String, Object>> getAdvertiserInfo(@RequestHeader("Access-Token") String accessToken,
                                                @RequestParam("advertiser_ids") Integer[] advertiserIds,
                                                @RequestParam("fields") String[] fields);

    /**
     * 获取广告主资质信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主id
     * @return advertiser qualification
     */
    @GetMapping(value = "qualification/get/")
    List<Object> getAdvertiserQualification(@RequestHeader("Access-Token") String accessToken, @RequestParam("advertiser_id") Integer advertiserId);


    /**
     * 提交广告主资质信息
     *
     * @param accessToken 访问凭证
     * @param subject     主体信息
     * @param others      开户资质列表
     * @param promotion   推广资质
     * @return list
     */
    @PostMapping(value = "qualification/submit/")
    List<Object> submitAdvertiserQualification(@RequestHeader("Access-Token") String accessToken,
                                               @RequestBody Object subject,
                                               @RequestBody Object[] others,
                                               @RequestBody Object promotion);



}
