package io.better.toutiao.api;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The interface Agent api.
 *
 * @author better create in 2019-04-27 11:17
 */
@FeignClient(name = "${toutiao.api.advertiser-url}", url = "/agent/advertiser")
public interface AgentApi {

    /**
     * 获取代理商下的广告主ID列表
     *
     * @param accessToken 访问凭证
     * @param agentId     代理商ID
     * @param page        当前页
     * @param pageSize    每页记录数
     * @return advertiser by agent id
     */
    @GetMapping(value = "/select")
    List<Object> getAdvertiserByAgentId(@RequestHeader("Access-Token") String accessToken,
                                        @RequestParam("advertiser_id") Integer agentId,
                                        @RequestParam(value = "page", defaultValue = "1") String page,
                                        @RequestParam(value = "page_size", defaultValue = "100") String pageSize);

    /**
     * 代理商创建广告主信息
     *
     * @param accessToken 访问凭证
     * @param object      创建信息
     * @return the list
     */
    @PostMapping(value = "/create")
    List<Object> createAdvertiserByAgent(@RequestHeader("Access-Token") String accessToken,
                                         @RequestBody Object object);

    /**
     * 代理商更新广告主信息
     *
     * @param accessToken 访问凭证
     * @param object      更新信息
     * @return the list
     */
    @PostMapping(value = "/update")
    List<Object> updateAdvertiserByAgent(@RequestHeader("Access-Token") String accessToken,
                                         @RequestBody Object object);


}
