package io.better.toutiao.api;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * @author better create in 2019-04-27 10:26
 */
@FeignClient(value = "${toutiao.api.oauth-url}", url = "/oauth2")
public interface OAuth2Api {

    /**
     * 根据appId，secret等信息获取access_token
     *
     * @param params 请求参数
     * @return
     */
    @PostMapping(value = "/access_token")
    Object getAccessToken(@RequestBody Map<String, Object> params);

    /**
     * 通过refresh_token刷新access_token和refresh_token
     *
     * @param params 请求参数
     * @return
     */
    @PostMapping(value = "/refresh_token")
    Map<String, Object> refreshToken(@RequestBody Map<String, Object> params);
}
