package io.better.toutiao.api.advertisingdelivery;

import io.better.toutiao.dto.BaseRespDTO;
import io.better.toutiao.dto.resp.AdvertisingGroupReqDTO;
import io.better.toutiao.dto.resp.AdvertisingGroupRespDTO;
import io.better.toutiao.dto.status.UpdateStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * The interface Advertising group api.
 *
 * @author better create in 2019-04-28 16:27
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2", url = "/campaign")
public interface AdvertisingGroupApi {

    /**
     * The constant BUDGET_MODE_INFINITE.
     */
    String BUDGET_MODE_INFINITE = "BUDGET_MODE_INFINITE";

    /**
     * The constant BUDGET_MODE_DAY.
     */
    String BUDGET_MODE_DAY = "BUDGET_MODE_DAY";

    /**
     * 广告投放-获取某广告主的广告组信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param page         当前页
     * @param pageSize     每页记录数
     * @param filtering    过滤字段
     * @param fields       查询字段
     * @return advertising group
     */
    @GetMapping(value = "/get")
    BaseRespDTO<AdvertisingGroupRespDTO> getAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                                             @RequestParam("advertiser_id") Long advertiserId,
                                                             @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                             @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                             @RequestParam(value = "filtering", required = false) Map<String, Object> filtering,
                                                             @RequestParam(value = "fields", required = false) String[] fields);

    /**
     * 广告投放-为某广告主创建广告组信息
     *
     * @param accessToken            访问凭证
     * @param advertisingGroupReqDTO 创建信息
     * @return the list
     */
    @PostMapping(value = "/create")
    BaseRespDTO<Long> createAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                             @RequestBody AdvertisingGroupReqDTO advertisingGroupReqDTO);

    /**
     * 广告投放-修改某广告主的广告组信息
     *
     * @param accessToken            访问凭证
     * @param advertisingGroupReqDTO 更新信息
     * @return the list
     */
    @PostMapping(value = "/update")
    BaseRespDTO<Long> updateAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                             @RequestBody AdvertisingGroupReqDTO advertisingGroupReqDTO);

    /**
     * 广告投放-修改某广告主的广告组状态信息
     *
     * @param accessToken     访问凭证
     * @param updateStatusDTO 更新状态信息
     * @return list list
     */
    @PostMapping(value = "/update/status")
    BaseRespDTO<Long> updateAdvertisingGroupStatus(@RequestHeader("Access-Token") String accessToken,
                                                   @RequestBody UpdateStatusDTO updateStatusDTO);

}
