package io.better.toutiao.api.advertisingdelivery;

import io.better.toutiao.dto.BaseRespDTO;
import io.better.toutiao.dto.advertisingdelivery.plan.AdvertisingPlanInDTO;
import io.better.toutiao.dto.budget.UpdateBidDTO;
import io.better.toutiao.dto.budget.UpdateBudgetDTO;
import io.better.toutiao.dto.resp.AdvertisingPlanRespDTO;
import io.better.toutiao.dto.status.UpdateStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * The interface Advertising plan api.
 *
 * @author better create in 2019-04-28 16:27
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2", url = "/ad")
public interface AdvertisingPlanApi {

    /**
     * 广告投放-获取某广告的广告计划
     *
     * @param accessToken  访问凭证
     * @param advertiserId the advertiser id
     * @param page         当前页
     * @param pageSize     每页记录数
     * @param filtering    过滤字段
     * @param fields       查询字段
     * @return advertising plan
     */
    @GetMapping(value = "/get")
    BaseRespDTO<List<AdvertisingPlanRespDTO>> getAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                                                 @RequestParam("advertiser_id") Long advertiserId,
                                                                 @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                                 @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                                 @RequestParam(value = "filtering", required = false) Map<String, Object> filtering,
                                                                 @RequestParam(value = "fields", required = false) String[] fields);


    /**
     * 广告投放-为某广告创建广告计划
     *
     * @param accessToken       访问凭证
     * @param advertisingPlanIn 更新对象
     * @return 广告计划ID
     */
    @PostMapping(value = "/create")
    BaseRespDTO<Integer> createAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                               @RequestBody AdvertisingPlanInDTO advertisingPlanIn
    );

    /**
     * 广告投放-更新某广告主的广告计划
     *
     * @param accessToken       访问凭证
     * @param advertisingPlanIn 更新信息
     * @return 广告计划ID
     */
    @PostMapping(value = "/update")
    BaseRespDTO<Integer> updateAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                               @RequestBody AdvertisingPlanInDTO advertisingPlanIn
    );

    /**
     * 广告投放-更新某广告主下广告计划状态，可以批量更新
     *
     * @param accessToken     访问凭证
     * @param updateStatusDTO 更新状态信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/status")
    BaseRespDTO<List<Integer>> updateAdvertisingPlanStatus(@RequestHeader("Access-Token") String accessToken,
                                                           @RequestBody UpdateStatusDTO updateStatusDTO);

    /**
     * 广告投放-更新某广告主下广告计划预算，可以批量更新
     *
     * @param accessToken  访问凭证
     * @param updateBudget 更新预算信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/budget")
    BaseRespDTO<List<Integer>> updateAdvertisingPlanBudget(@RequestHeader("Access-Token") String accessToken,
                                                           @RequestBody UpdateBudgetDTO updateBudget);

    /**
     * 广告投放-更新某广告主下广告计划出价，可以批量更新
     *
     * @param accessToken 访问凭证
     * @param updateBid   更新预算信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/bid")
    BaseRespDTO<List<Integer>> updateAdvertisingPlanBid(@RequestHeader("Access-Token") String accessToken,
                                                        @RequestBody UpdateBidDTO updateBid);
}
