package io.better.toutiao.dto.advertisingdelivery.plan;

import lombok.Data;

/**
 * @author better create in 2019-04-29 10:23
 */
@Data
public class AdvertisingPlanInDTO {

    /**
     * 广告主ID
     */
    private Integer advertiserId;

    /**
     * 广告组ID
     */
    private String campaignId;

    /**
     * 投放范围
     */
    private String deliveryRange;

    /**
     * 广告预算类型
     */
    private String budgetMode;

    /**
     * 广告预算
     */
    private Long budget;

    /**
     * 广告投放起始时间
     */
    private String startTime;

    /**
     * 广告投放结束时间
     */
    private String endTime;

    /**
     * 广告出价
     */
    private Long bid;

    /**
     * 计划出价类型
     */
    private String pricing;

    /**
     * 广告投放时间类型
     */
    private String scheduleType;

    /**
     * 广告投放时段
     */
    private String scheduleTime;

    /**
     * 广告投放速度类型
     */
    private String flowControlMode;

    /**
     * 应用直达链接
     */
    private String openUrl;

    /**
     * 应用下载方式
     */
    private String downloadType;

    /**
     * 广告落地页链接
     */
    private String externalUrl;

    /**
     * 应用下载方式
     */
    private String downloadUrl;

    /**
     * 广告名称
     */
    private String name;

    /**
     * 应用广告下载类型
     */
    private String appType;

    /**
     * 广告应用下载包名
     */
    private String packageName;

    /**
     * 过滤已转化用户类型的字段，只有转化为目标时可填
     */
    private String hideIfConverted;

    /**
     * 过滤已安装，允许值: 0, 1
     */
    private Long hideIfExists;

    /**
     * ocpm广告转化出价
     */
    private Long cpaBid;

    /**
     * 转换ID
     */
    private Long convertId;

    /**
     * 穿山甲视频创意类型，允许值：ORIGINAL_VIDEO，REWARDED_VIDEO
     */
    private String unionVideoType;

    /**
     * 深度优化方式
     */
    private String deepBidType;

    /**
     * 深度优化出价，deep_bid_type=DEEP_BID_MIN时必填
     */
    private Long deepCpabid;

    /**
     * 第三方唯一键
     */
    private String uniqueFk;
}
