package io.better.toutiao.dto.resp;

import lombok.Data;

/**
 * @author better create in 2019-04-29 14:21
 */
@Data
public class AdvertisingGroupRespDTO {

    /**
     * 广告组ID
     */
    private Long id;

    /**
     * 广告组名称
     */
    private String name;

    /**
     * 广告组预算
     */
    private Integer budget;

    /**
     * 广告组预算类型
     */
    private String budgetMode;

    /**
     * 广告组推广目的
     *
     * @see io.better.toutiao.enums.LandingType
     */
    private String landingType;

    /**
     * 广告组时间戳,用于更新时提交,服务端判断是否基于最新信息修改
     */
    private String modifyTime;

    /**
     * 广告组状态
     *
     * @see io.better.toutiao.enums.AdvertisingGroupStatus
     */
    private String status;

    /**
     * 广告组创建时间
     */
    private String campaignCreateTime;

    /**
     * 广告组修改时间
     */
    private String campaignModifyTime;

    /**
     * 分页信息
     */
    private PageRespDTO pageInfo;

    /**
     * 第三方唯一键
     */
    private String uniqueFk;
}
