package io.better.toutiao.dto.resp;

import io.better.toutiao.dto.AudienceDTO;
import lombok.Data;

/**
 * @author better create in 2019-04-29 14:21
 */
@Data
public class AdvertisingPlanRespDTO {

    /**
     * 广告组ID
     */
    private Long id;

    /**
     * 广告组名称
     */
    private String name;

    /**
     * 广告主ID
     */
    private Long advertiserId;

    /**
     * 广告组ID
     */
    private Long campaignId;

    /**
     * 广告组时间戳,用于更新时提交,服务端判断是否基于最新信息修改
     */
    private String modifyTime;

    /**
     * 投放范围
     */
    private String deliveryRange;

    /**
     * 计划上次修改时间
     */
    private String adModifyTime;

    /**
     * 计划创建时间
     */
    private String adCreateTime;

    /**
     * 广告组预算
     */
    private Integer budget;

    /**
     * 广告组预算类型
     */
    private String budgetMode;

    /**
     * 广告组推广目的
     *
     * @see io.better.toutiao.enums.LandingType
     */
    private String landingType;

    /**
     * 广告计划投放状态
     *
     * @see io.better.toutiao.enums.AdvertisingPlanDeliveryStatus
     */
    private String status;

    /**
     * 广告计划操作状态
     */
    private String optStatus;

    /**
     * 广告投放起始时间
     */
    private String startTime;

    /**
     * 广告投放结束时间
     */
    private String endTime;

    /**
     * 广告出价
     */
    private Integer bid;

    /**
     * 广告出价类型
     */
    private String pricing;

    /**
     * 广告投放时间类型
     */
    private String scheduleType;

    /**
     * 广告投放时段
     */
    private String scheduleTime;

    /**
     * 广告投放速度类型
     */
    private String flowControlMode;

    /**
     * 应用直达链接
     */
    private String openUrl;

    /**
     * 应用下载方式
     */
    private String downloadType;

    /**
     * 广告落地页链接
     */
    private String externalUrl;

    /**
     * 广告应用下载链接
     */
    private String downloadUrl;

    /**
     * 广告应用下载类型
     */
    private String appType;

    /**
     * 广告应用下载包名
     */
    private String packageName;

    /**
     * 广告计划审核不通过原因
     */
    private String auditRejectReason;

    /**
     * ocpc广告转化出价,如果是cpc或cpm出价方式则使用bid字段
     */
    private Integer cpaBid;

    /**
     * ocpc广告是否跳过第一阶段，0表示不跳过，1表示跳过
     * (此参数将于2018年7月13日下线，ocpc将与ocpm保持一致，ocpc会默认进入第二阶段)
     */
    private Integer cpaSkipFirstPhrase;

    /**
     * 转化类型广告的转化工具id
     */
    private Integer convertId;

    /**
     * 过滤已转化用户类型字段，只有转化为目标时可填
     */
    private String hideIfConverted;

    /**
     * 过滤已安装，当推广目标为安卓应用下载时可填，0表示不过滤，1表示过滤，默认为不过滤
     */
    private Integer hideIfExists;

    /**
     * 广告受众
     */
    private AudienceDTO audience;

    /**
     * 分页信息
     */
    private PageRespDTO pageInfo;

    /**
     * 第三方唯一键
     */
    private String uniqueFk;

    /**
     * 设置package属性
     *
     * @param packageName
     */
    public void setPackage(String packageName) {
        this.packageName = packageName;
    }
}
