package io.better.toutiao.enums;

import lombok.Getter;

/**
 * 广告计划投放状态
 *
 * @author better create in 2019-04-29 15:07
 */
@Getter
public enum AdvertisingPlanDeliveryStatus {

    /**
     * 投放中
     */
    AD_STATUS_DELIVERY_OK,

    /**
     * 数据错误
     */
    AD_STATUS_DATA_ERROR,

    /**
     * 计划暂停
     */
    AD_STATUS_DISABLE,

    /**
     * 新建审核中
     */
    AD_STATUS_AUDIT,

    /**
     * 修改审核中
     */
    AD_STATUS_REAUDIT,

    /**
     * 已完成（投放达到结束时间）
     */
    AD_STATUS_DONE,

    /**
     * 计划新建
     */
    AD_STATUS_CREATE,

    /**
     * 审核不通过
     */
    AD_STATUS_AUDIT_DENY,

    /**
     * 账户余额不足
     */
    AD_STATUS_BALANCE_EXCEED,

    /**
     * 超出预算
     */
    AD_STATUS_BUDGET_EXCEED,

    /**
     * 未到达投放时间
     */
    AD_STATUS_NOT_START,

    /**
     * 不在投放时段
     */
    AD_STATUS_NO_SCHEDULE,

    /**
     * 已被广告组暂停
     */
    AD_STATUS_CAMPAIGN_DISABLE,

    /**
     * 广告组超出预算
     */
    AD_STATUS_CAMPAIGN_EXCEED,

    /**
     * 已删除
     */
    AD_STATUS_DELETE,

    /**
     * 已冻结
     */
    AD_STATUS_FROZEN,

    /**
     * 部分投放中
     */
    AD_STATUS_SOME_DELIVERY_OK,

    /**
     * 所有包含已删除
     */
    AD_STATUS_ALL,

    /**
     * 所有不包含已删除（状态过滤默认值）
     */
    AD_STATUS_NOT_DELETE,

    /**
     * 超出账户日预算
     */
    AD_STATUS_ADVERTISER_BUDGET_EXCEED;
}
