package io.better.toutiao.service.datareport.impl;

import io.better.toutiao.api.datareport.DataReportApi;
import io.better.toutiao.dto.datareport.DataReportQueryDTO;
import io.better.toutiao.service.datareport.DataReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * The type Data report service.
 *
 * @author better create in 2019-04-28 16:12
 */
@Service
public class DataReportServiceImpl implements DataReportService {

    private DataReportApi dataReportApi;

    /**
     * Instantiates a new Data report service.
     *
     * @param dataReportApi the data report api
     */
    @Autowired
    public DataReportServiceImpl(DataReportApi dataReportApi) {
        this.dataReportApi = dataReportApi;
    }

    /**
     * 获取广告主报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertisers report data
     */
    @Override
    public List<Object> getAdvertisersReportData(DataReportQueryDTO dataReportQueryDTO) {
        return dataReportApi.getAdvertisersReportData(dataReportQueryDTO.getAccessToken(), dataReportQueryDTO.getAdvertiserId(),
                dataReportQueryDTO.getStartDate(), dataReportQueryDTO.getEndDate(), dataReportQueryDTO.getPage(), dataReportQueryDTO.getPageSize(), dataReportQueryDTO.getTimeGranularity());
    }

    /**
     * 获取某广告主的广告组报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising group report data
     */
    @Override
    public List<Object> getAdvertisingGroupReportData(DataReportQueryDTO dataReportQueryDTO) {
        return dataReportApi.getAdvertisingGroupReportData(dataReportQueryDTO.getAccessToken(), dataReportQueryDTO.getAdvertiserId(),
                dataReportQueryDTO.getStartDate(), dataReportQueryDTO.getEndDate(), dataReportQueryDTO.getPage(), dataReportQueryDTO.getPageSize(),
                dataReportQueryDTO.getGroupBy(), dataReportQueryDTO.getTimeGranularity(), dataReportQueryDTO.getFiltering());
    }

    /**
     * 获取某广告主的广告计划报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising plan report data
     */
    @Override
    public List<Object> getAdvertisingPlanReportData(DataReportQueryDTO dataReportQueryDTO) {
        return dataReportApi.getAdvertisingPlanReportData(dataReportQueryDTO.getAccessToken(), dataReportQueryDTO.getAdvertiserId(),
                dataReportQueryDTO.getStartDate(), dataReportQueryDTO.getEndDate(), dataReportQueryDTO.getPage(), dataReportQueryDTO.getPageSize(),
                dataReportQueryDTO.getGroupBy(), dataReportQueryDTO.getTimeGranularity(), dataReportQueryDTO.getFiltering());
    }

    /**
     * 获取某广告主的广告创意报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising creative report data
     */
    @Override
    public List<Object> getAdvertisingCreativeReportData(DataReportQueryDTO dataReportQueryDTO) {
        return dataReportApi.getAdvertisingCreativeReportData(dataReportQueryDTO.getAccessToken(), dataReportQueryDTO.getAdvertiserId(),
                dataReportQueryDTO.getStartDate(), dataReportQueryDTO.getEndDate(), dataReportQueryDTO.getPage(), dataReportQueryDTO.getPageSize(),
                dataReportQueryDTO.getGroupBy(), dataReportQueryDTO.getTimeGranularity(), dataReportQueryDTO.getFiltering());
    }
}
