package io.better.toutiao;

import feign.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;

/**
 * The type Tou tiao api application.
 */
@SpringBootApplication
@EnableFeignClients
public class TouTiaoApiApplication {

    /**
     * The entry point of application.
     *
     * @param args the input arguments
     */
    public static void main(String[] args) {
        SpringApplication.run(TouTiaoApiApplication.class, args);
    }

    @Bean
    Logger.Level feignLevel() {
        return Logger.Level.FULL;
    }
}
