package io.better.toutiao.api.account;

import io.better.toutiao.dto.TouTiaoRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 账号管家Api
 *
 * @author better create in 2019-05-07 15:15
 */
@FeignClient(value = "${toutiao.api.advertiser-url}", url = "/majordomo")
public interface AccountApi {

    /**
     * 账号服务-账号管家-广告主列表
     *
     * @param accessToken  the access token
     * @param advertiserId the advertiser id
     * @return the advertiser list
     */
    @GetMapping(value = "/advertiser/select/")
    TouTiaoRespDTO<?> getAdvertiserList(@RequestHeader("Access-Token") String accessToken,
                                        @RequestParam("advertiser_id") Long advertiserId);
}
