package io.better.toutiao.api.account;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.account.AdvertiserInfoReqRespDTO;
import io.better.toutiao.dto.account.AdvertiserQualificationReqRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * The interface Advertiser api.
 *
 * @author better create in 2019-04-27 10:47
 */
@FeignClient(name = "${toutiao.api.advertiser-url}", url = "/advertiser")
public interface AdvertiserApi {

    /**
     * 账号服务-获取广告主信息
     *
     * @param accessToken   accessToken
     * @param advertiserIds 广告主ID数组
     * @param fields        字段数组
     * @return the advertiser info
     */
    @GetMapping(value = "/info")
    TouTiaoRespDTO<AdvertiserInfoReqRespDTO> getAdvertiserInfo(@RequestHeader("Access-Token") String accessToken,
                                                               @RequestParam("advertiser_ids") Long[] advertiserIds,
                                                               @RequestParam("fields") String[] fields
    );

    /**
     * 账号服务-获取广告主资质信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主id
     * @return advertiser qualification
     */
    @GetMapping(value = "/qualification/get/")
    TouTiaoRespDTO<AdvertiserQualificationReqRespDTO> getAdvertiserQualification(@RequestHeader("Access-Token") String accessToken,
                                                                                 @RequestParam("advertiser_id") Integer advertiserId
    );


    /**
     * 账号服务-提交广告主资质信息
     *
     * @param accessToken             访问凭证
     * @param advertiserQualification 资质信息
     * @return list list
     */
    @PostMapping(value = "qualification/submit/")
    TouTiaoRespDTO<?> submitAdvertiserQualification(@RequestHeader("Access-Token") String accessToken,
                                                    @RequestBody AdvertiserQualificationReqRespDTO advertiserQualification
    );


    /**
     * 账号服务-广告主公开信息
     *
     * @param accessToken   访问凭证
     * @param advertiserIds 广告主ID集合
     * @return the advertiser public info
     */
    @GetMapping(value = "/public_info")
    TouTiaoRespDTO<AdvertiserInfoReqRespDTO> getAdvertiserPublicInfo(@RequestHeader("Access-Token") String accessToken,
                                                                     @RequestParam("advertiser_ids") Long[] advertiserIds
    );

}
