package io.better.toutiao.api.account;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.account.AdvertiserInfoReqRespDTO;
import io.better.toutiao.dto.account.AdvertiserRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * The interface Agent api.
 *
 * @author better create in 2019-04-27 11:17
 */
@FeignClient(name = "${toutiao.api.advertiser-url}", url = "/agent/")
public interface AgentApi {

    /**
     * 账号服务-代理商账号-获取广告主列表
     *
     * @param accessToken  访问凭证
     * @param advertiserId 代理商ID
     * @param page         当前页
     * @param pageSize     每页记录数
     * @return advertiser by agent id
     */
    @GetMapping(value = "/advertiser/select")
    TouTiaoRespDTO<AdvertiserRespDTO> getAdvertiserByAgentId(@RequestHeader("Access-Token") String accessToken,
                                                             @RequestParam("advertiser_id") Long advertiserId,
                                                             @RequestParam(value = "page", defaultValue = "1", required = false) String page,
                                                             @RequestParam(value = "page_size", defaultValue = "100", required = false) String pageSize);

    /**
     * 账号服务-代理商账号-创建广告主信息
     *
     * @param accessToken    访问凭证
     * @param advertiserInfo 创建信息
     * @return the list
     */
    @PostMapping(value = "/advertiser/create")
    TouTiaoRespDTO<AdvertiserInfoReqRespDTO> createAdvertiserByAgent(@RequestHeader("Access-Token") String accessToken,
                                                                     @RequestBody AdvertiserInfoReqRespDTO advertiserInfo);

    /**
     * 账号服务-代理商账号-更新广告主信息
     *
     * @param accessToken    访问凭证
     * @param advertiserInfo 更新信息
     * @return the list
     */
    @PostMapping(value = "/advertiser/update")
    TouTiaoRespDTO<AdvertiserInfoReqRespDTO> updateAdvertiserByAgent(@RequestHeader("Access-Token") String accessToken,
                                                                     @RequestBody AdvertiserInfoReqRespDTO advertiserInfo);


    /**
     * 账号服务-代理商账号-获取二级代理商
     *
     * @param accessToken 访问凭证
     * @param page        当前页
     * @param pageSize    每页记录数
     * @return the second agent
     */
    @GetMapping(value = "/child_agent/select/")
    TouTiaoRespDTO<AdvertiserRespDTO> getSecondAgent(@RequestHeader("Access-Token") String accessToken,
                                                     @RequestParam(value = "page", defaultValue = "1", required = false) String page,
                                                     @RequestParam(value = "page_size", defaultValue = "100", required = false) String pageSize);
}
