package io.better.toutiao.api.account;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.account.AccountBalanceRespDTO;
import io.better.toutiao.dto.account.AccountDayFundFlowRespDTO;
import io.better.toutiao.dto.account.FundFlowRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 账号服务-资金流水
 *
 * @author better create in 2019-05-07 16:45
 */
@FeignClient(value = "${toutiao.api.advertiser-url}", url = "/advertiser/fund")
public interface FundFlowApi {

    /**
     * 账号服务-资金流水-查询账户余额
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @return the account balance
     */
    @GetMapping(value = "/get")
    TouTiaoRespDTO<AccountBalanceRespDTO> getAccountBalance(@RequestHeader("Access-Token") String accessToken,
                                                            @RequestParam("advertiser_id") Long advertiserId);


    /**
     * 账号服务-资金流水-查询账号日流水
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param startDate    开始时间
     * @param endDate      结束时间
     * @param page         第几页
     * @param pageSize     每页记录数
     * @return the account balance
     */
    @GetMapping(value = "/daily_stat")
    TouTiaoRespDTO<AccountDayFundFlowRespDTO> getAccountDayFundFlow(@RequestHeader("Access-Token") String accessToken,
                                                                    @RequestParam("advertiser_id") Long advertiserId,
                                                                    @RequestParam(value = "start_date", required = false) String startDate,
                                                                    @RequestParam(value = "end_date", required = false) String endDate,
                                                                    @RequestParam(value = "page", required = false, defaultValue = "1") Integer page,
                                                                    @RequestParam(value = "page_size", required = false, defaultValue = "10") Integer pageSize
    );

    /**
     * 账号服务-资金流水-查询账号流水明细
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主ID
     * @param startDate       开始时间
     * @param endDate         结束时间
     * @param transactionType 流水类型
     * @param page            第几页
     * @param pageSize        每页记录数
     * @return the account balance
     * @see io.better.toutiao.enums.FlowType 查看流水类型取值
     */
    @GetMapping(value = "/transaction/get")
    TouTiaoRespDTO<FundFlowRespDTO> getAccountFundFlowDetail(@RequestHeader("Access-Token") String accessToken,
                                                             @RequestParam("advertiser_id") Long advertiserId,
                                                             @RequestParam(value = "start_date") String startDate,
                                                             @RequestParam(value = "end_date") String endDate,
                                                             @RequestParam(value = "transaction_type") String transactionType,
                                                             @RequestParam(value = "page", required = false, defaultValue = "1") Integer page,
                                                             @RequestParam(value = "page_size", required = false, defaultValue = "10") Integer pageSize
    );
}
