package io.better.toutiao.api.datareport;

import io.better.toutiao.dto.TouTiaoRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * The interface Data report api.
 *
 * @author better create in 2019-04-28 11:18
 */
@FeignClient(value = "${toutiao.api.oauth-url}", url = "/report")
public interface DataReportApi {

    /**
     * The constant STAT_TIME_GRANULARITY_DAILY.
     */
    String STAT_TIME_GRANULARITY_DAILY = "STAT_TIME_GRANULARITY_DAILY";
    /**
     * The constant STAT_TIME_GRANULARITY_HOURLY.
     */
    String STAT_TIME_GRANULARITY_HOURLY = "STAT_TIME_GRANULARITY_HOURLY";

    /**
     * 获取广告主报表数据
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主id
     * @param startDate       开始时间
     * @param endDate         结束时间
     * @param page            当前页
     * @param pageSize        页数量
     * @param timeGranularity 时间粒度，STAT_TIME_GRANULARITY_DAILY， STAT_TIME_GRANULARITY_HOURLY 两个取值
     * @return advertisers report data
     */
    @GetMapping(value = "/advertiser/get/", consumes = "application/json")
    List<Object> getAdvertisersReportData(@RequestHeader("Access-Token") String accessToken,
                                          @RequestParam("advertiser_id") Long advertiserId,
                                          @RequestParam("start_date") String startDate,
                                          @RequestParam("end_date") String endDate,
                                          @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                          @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                          @RequestParam(value = "time_granularity", defaultValue = STAT_TIME_GRANULARITY_DAILY, required = false) String timeGranularity);

    /**
     * 获取广告组报表数据
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主id
     * @param startDate       开始时间
     * @param endDate         结束时间
     * @param page            当前页
     * @param pageSize        页数量
     * @param groupBy         the group by
     * @param timeGranularity 时间粒度，STAT_TIME_GRANULARITY_DAILY， STAT_TIME_GRANULARITY_HOURLY 两个取值
     * @param filtering       过滤字段
     * @return advertising group report data
     */
    @GetMapping(value = "/campaign/get/", consumes = "application/json")
    List<Object> getAdvertisingGroupReportData(@RequestHeader("Access-Token") String accessToken,
                                               @RequestParam("advertiser_id") Long advertiserId,
                                               @RequestParam("start_date") String startDate,
                                               @RequestParam("end_date") String endDate,
                                               @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                               @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                               @RequestParam(value = "group_by", required = false) String[] groupBy,
                                               @RequestParam(value = "time_granularity", defaultValue = STAT_TIME_GRANULARITY_DAILY, required = false) String timeGranularity,
                                               @RequestParam(value = "filtering", required = false) Map<String, Object> filtering);

    /**
     * 获取广告计划报表数据
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主id
     * @param startDate       开始时间
     * @param endDate         结束时间
     * @param page            当前页
     * @param pageSize        页数量
     * @param groupBy         the group by
     * @param timeGranularity 时间粒度，STAT_TIME_GRANULARITY_DAILY， STAT_TIME_GRANULARITY_HOURLY 两个取值
     * @param filtering       过滤字段
     * @return advertising plan report data
     */
    @GetMapping(value = "/ad/get/", consumes = "application/json")
    TouTiaoRespDTO<?> getAdvertisingPlanReportData(@RequestHeader("Access-Token") String accessToken,
                                                   @RequestParam("advertiser_id") Long advertiserId,
                                                   @RequestParam("start_date") String startDate,
                                                   @RequestParam("end_date") String endDate,
                                                   @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                   @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                   @RequestParam(value = "group_by", required = false) String[] groupBy,
                                                   @RequestParam(value = "time_granularity", defaultValue = STAT_TIME_GRANULARITY_DAILY, required = false) String timeGranularity,
                                                   @RequestParam(value = "filtering", required = false) Map<String, Object> filtering);

    /**
     * 获取广告创意报表数据
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主id
     * @param startDate       开始时间
     * @param endDate         结束时间
     * @param page            当前页
     * @param pageSize        页数量
     * @param groupBy         the group by
     * @param timeGranularity 时间粒度，STAT_TIME_GRANULARITY_DAILY， STAT_TIME_GRANULARITY_HOURLY 两个取值
     * @param filtering       过滤字段
     * @return advertising creative report data
     */
    @GetMapping(value = "/creative/get/", consumes = "application/json")
    List<Object> getAdvertisingCreativeReportData(@RequestHeader("Access-Token") String accessToken,
                                                  @RequestParam("advertiser_id") Long advertiserId,
                                                  @RequestParam("start_date") String startDate,
                                                  @RequestParam("end_date") String endDate,
                                                  @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                  @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                  @RequestParam(value = "group_by", required = false) String[] groupBy,
                                                  @RequestParam(value = "time_granularity", defaultValue = STAT_TIME_GRANULARITY_DAILY, required = false) String timeGranularity,
                                                  @RequestParam(value = "filtering", required = false) Map<String, Object> filtering);
}
