package io.better.toutiao.api.delivery;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.delivery.budget.AccountBudgetDTO;
import io.better.toutiao.dto.delivery.budget.AccountBudgetRespDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 账号日预算Api
 *
 * @author better create in 2019-05-07 17:42
 */
@FeignClient(value = "${toutiao.api.advertiser-url}", url = "/advertiser/")
public interface AccountDayBudgetApi {

    /**
     * 广告投放-账号日预算-获取账号日预算
     *
     * @param accessToken   访问凭证
     * @param advertiserIds 广告主ID集合
     * @return the account day budget
     */
    @GetMapping(value = "/budget/get")
    TouTiaoRespDTO<AccountBudgetRespDTO> getAccountDayBudget(@RequestHeader("Access-Token") String accessToken,
                                                             @RequestParam("advertiser_ids") Long[] advertiserIds
    );


    /**
     * 广告投放-账号日预算-更新账号日预算
     *
     * @param accessToken   访问凭证
     * @param accountBudget 预算信息
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/update/budget")
    TouTiaoRespDTO<?> updateAccountDayBudget(@RequestHeader("Access-Token") String accessToken,
                                             @RequestBody AccountBudgetDTO accountBudget
    );
}
