package io.better.toutiao.api.delivery;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.delivery.group.AdGroupInfoDTO;
import io.better.toutiao.dto.delivery.group.AdGroupRespDTO;
import io.better.toutiao.dto.status.UpdateStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * The interface Advertising group api.
 *
 * @author better create in 2019-04-28 16:27
 */
@FeignClient(value = "${toutiao.api.advertiser-url}", url = "/campaign")
public interface AdGroupApi {

    /**
     * 广告投放-获取广告组信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param page         当前页
     * @param pageSize     每页记录数
     * @param filtering    过滤字段
     * @param fields       查询字段
     * @return advertising group
     */
    @GetMapping(value = "/get")
    TouTiaoRespDTO<AdGroupRespDTO> getAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                                       @RequestParam("advertiser_id") Long advertiserId,
                                                       @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                       @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                       @RequestParam(value = "filtering", required = false) Map<String, Object> filtering,
                                                       @RequestParam(value = "fields", required = false) String[] fields
    );

    /**
     * 广告投放-创建广告组信息
     *
     * @param accessToken 访问凭证
     * @param adGroupInfo 创建信息
     * @return the list
     */
    @PostMapping(value = "/create")
    TouTiaoRespDTO<AdGroupRespDTO> createAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                                          @RequestBody AdGroupInfoDTO adGroupInfo
    );

    /**
     * 广告投放-修改广告组信息
     *
     * @param accessToken 访问凭证
     * @param adGroupInfo 更新信息
     * @return the list
     */
    @PostMapping(value = "/update")
    TouTiaoRespDTO<AdGroupRespDTO> updateAdvertisingGroup(@RequestHeader("Access-Token") String accessToken,
                                                          @RequestBody AdGroupInfoDTO adGroupInfo
    );

    /**
     * 广告投放-修改某广告主的广告组状态信息
     *
     * @param accessToken     访问凭证
     * @param updateStatusDTO 更新状态信息
     * @return list list
     */
    @PostMapping(value = "/update/status")
    TouTiaoRespDTO<AdGroupRespDTO> updateAdvertisingGroupStatus(@RequestHeader("Access-Token") String accessToken,
                                                      @RequestBody UpdateStatusDTO updateStatusDTO
    );

}
