package io.better.toutiao.api.delivery;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.delivery.plan.AdPlanRespDTO;
import io.better.toutiao.dto.delivery.plan.AdvertisingPlanInfoDTO;
import io.better.toutiao.dto.delivery.plan.PlanBidDTO;
import io.better.toutiao.dto.delivery.plan.PlanBudgetDTO;
import io.better.toutiao.dto.status.UpdateStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * The interface Advertising plan api.
 *
 * @author better create in 2019-04-28 16:27
 */
@FeignClient(value = "${toutiao.api.advertiser-url}", url = "/ad")
public interface AdPlanApi {

    /**
     * 广告投放-获取广告计划
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param page         当前页
     * @param pageSize     每页记录数
     * @param filtering    过滤字段
     * @param fields       查询字段
     * @return advertising plan
     */
    @GetMapping(value = "/get")
    TouTiaoRespDTO<AdPlanRespDTO> getAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                                     @RequestParam("advertiser_id") Long advertiserId,
                                                     @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                     @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                     @RequestParam(value = "filtering", required = false) Map<String, Object> filtering,
                                                     @RequestParam(value = "fields", required = false) String[] fields
    );


    /**
     * 广告投放-创建广告计划
     *
     * @param accessToken       访问凭证
     * @param advertisingPlanIn 更新对象
     * @return 广告计划ID
     */
    @PostMapping(value = "/create")
    TouTiaoRespDTO<AdPlanRespDTO> createAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                                        @RequestBody AdvertisingPlanInfoDTO advertisingPlanIn
    );

    /**
     * 广告投放-更新广告计划
     *
     * @param accessToken         访问凭证
     * @param advertisingPlanInfo 更新信息
     * @return 广告计划ID
     */
    @PostMapping(value = "/update")
    TouTiaoRespDTO<AdPlanRespDTO> updateAdvertisingPlan(@RequestHeader("Access-Token") String accessToken,
                                                        @RequestBody AdvertisingPlanInfoDTO advertisingPlanInfo
    );

    /**
     * 广告投放-更新广告计划状态，可以批量更新
     *
     * @param accessToken  访问凭证
     * @param updateStatus 更新状态信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/status")
    TouTiaoRespDTO<AdPlanRespDTO> updateAdvertisingPlanStatus(@RequestHeader("Access-Token") String accessToken,
                                                              @RequestBody UpdateStatusDTO updateStatus);

    /**
     * 广告投放-更新某广告主下广告计划预算，可以批量更新
     *
     * @param accessToken  访问凭证
     * @param updateBudget 更新预算信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/budget")
    TouTiaoRespDTO<AdPlanRespDTO> updateAdvertisingPlanBudget(@RequestHeader("Access-Token") String accessToken,
                                                              @RequestBody PlanBudgetDTO.UpdateBudgetDTO updateBudget);

    /**
     * 广告投放-更新某广告主下广告计划出价，可以批量更新
     *
     * @param accessToken 访问凭证
     * @param updateBid   更新预算信息
     * @return 广告计划ID集合
     */
    @PostMapping(value = "/update/bid")
    TouTiaoRespDTO<AdPlanRespDTO> updateAdvertisingPlanBid(@RequestHeader("Access-Token") String accessToken,
                                                           @RequestBody PlanBidDTO.UpdateBidDTO updateBid);
}
