package io.better.toutiao.api.delivery;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.delivery.creative.AdvertisingCreativeInfoDTO;
import io.better.toutiao.dto.delivery.creative.AdvertisingCreativeDTO;
import io.better.toutiao.dto.status.UpdateStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * The interface Advertising creative api.
 *
 * @author better create in 2019-04-28 16:27
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2", url = "/creative")
public interface AdvertisingCreativeApi {

    /**
     * 广告投放-获取某广告主的广告创意信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param page         当前页
     * @param pageSize     每页记录数
     * @param filtering    过滤字段
     * @param fields       查询字段
     * @return 广告创意信息 base resp dto
     */
    @GetMapping(value = "/get")
    TouTiaoRespDTO<AdvertisingCreativeDTO> listAdvertisingCreative(@RequestHeader("Access-Token") String accessToken,
                                                                   @RequestParam("advertiser_id") Long advertiserId,
                                                                   @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                                   @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize,
                                                                   @RequestParam(value = "filtering", required = false) Map<String, Object> filtering,
                                                                   @RequestParam(value = "fields", required = false) String[] fields);

    /**
     * 广告投放-为某广告主下的某计划创建广告创意
     *
     * @param accessToken             访问凭证
     * @param advertisingCreativeInfo 创建信息
     * @return the base resp dto
     */
    @PostMapping(value = "/create_v2")
    TouTiaoRespDTO<Integer> createAdvertisingCreative(@RequestHeader("Access-Token") String accessToken,
                                                      @RequestBody AdvertisingCreativeInfoDTO advertisingCreativeInfo);

    /**
     * 广告投放-查看某广告主下某计划下的创意详情信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param adId         计划ID
     * @return the advertising creative detail info
     */
    @GetMapping(value = "/read_v2")
    TouTiaoRespDTO<AdvertisingCreativeInfoDTO> getAdvertisingCreativeDetailInfo(@RequestHeader("Access-Token") String accessToken,
                                                                                @RequestParam("advertiser_id") Integer advertiserId,
                                                                                @RequestParam("ad_id") Integer adId);

    /**
     * 广告投放-更新具体广告计划下创意详情信息
     *
     * @param accessToken             访问凭证
     * @param advertisingCreativeInfo 更新信息
     * @return the base resp dto
     */
    @PostMapping(value = "/update_v2")
    TouTiaoRespDTO<Integer> updateAdvertisingCreativeDetailInfo(@RequestHeader("Access-Token") String accessToken,
                                                                @RequestBody AdvertisingCreativeInfoDTO advertisingCreativeInfo);

    /**
     * 广告投放-更新某个广告创意状态
     *
     * @param accessToken  访问凭证
     * @param updateStatus 更新状态信息
     * @return the base resp dto
     */
    @PostMapping(value = "/update/status")
    TouTiaoRespDTO<List<Long>> updateAdvertisingCreativeStatus(@RequestHeader("Access-Token") String accessToken,
                                                               @RequestBody UpdateStatusDTO updateStatus);

    /**
     * 广告投放-获取光广告创意下的素材信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param creativeIds  广告创意ID
     * @param fields       广告创意获取字段
     * @return
     */
    @GetMapping(value = "/material/read")
    TouTiaoRespDTO<?> getCreativeMaterial(@RequestHeader("Access-Token") String accessToken,
                                          @RequestParam("advertiser_id") Long advertiserId,
                                          @RequestParam("creative_ids") Long[] creativeIds,
                                          @RequestParam("fields") String[] fields);
}
