package io.better.toutiao.api.util;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.util.ConvertTargetCallBackDTO;
import io.better.toutiao.dto.util.ConvertTargetDTO;
import io.better.toutiao.dto.util.ConvertTargetPushDTO;
import io.better.toutiao.dto.util.ConvertTargetStatusDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 转换目标Api
 *
 * @author better create in 2019-05-07 10:37
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2", url = "/tools")
public interface ConvertTargetApi {

    /**
     * Create convert target tou tiao resp dto.
     *
     * @param accessToken   the access token
     * @param convertTarget the convert target
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/ad_convert/create")
    TouTiaoRespDTO<ConvertTargetStatusDTO> createConvertTarget(@RequestHeader("Access-Token") String accessToken,
                                                               @RequestBody ConvertTargetDTO convertTarget);

    /**
     * Update convert target tou tiao resp dto.
     *
     * @param accessToken   the access token
     * @param convertTarget the convert target
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/ad_convert/update")
    TouTiaoRespDTO<?> updateConvertTarget(@RequestHeader("Access-Token") String accessToken,
                                          @RequestBody ConvertTargetDTO convertTarget);


    /**
     * Update convert target status tou tiao resp dto.
     *
     * @param accessToken   the access token
     * @param convertTarget the convert target
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/ad_convert/update_status/")
    TouTiaoRespDTO<ConvertTargetStatusDTO> updateConvertTargetStatus(@RequestHeader("Access-Token") String accessToken,
                                                                     @RequestBody ConvertTargetDTO convertTarget);


    /**
     * 工具-转化ID推送
     *
     * @param accessToken       the access token
     * @param convertTargetPush the convert target push
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/ad_convert/push")
    TouTiaoRespDTO<ConvertTargetStatusDTO> pushConvertTarget(@RequestHeader("Access-Token") String accessToken,
                                                             @RequestBody ConvertTargetPushDTO convertTargetPush);

    /**
     * 工具-查询计划可用转化ID
     *
     * @param accessToken  the access token
     * @param advertiserId the advertiser id
     * @param packageName  the package name
     * @param itunesUrl    the itunes url
     * @param fields       the fields
     * @return the tou tiao resp dto
     */
    @GetMapping(value = "/ad_convert/select")
    TouTiaoRespDTO<ConvertTargetCallBackDTO> listConvertTarget(@RequestHeader("Access-Token") String accessToken,
                                                               @RequestParam("advertiser_id") Long advertiserId,
                                                               @RequestParam("package_name") String packageName,
                                                               @RequestParam("itunes_url") String itunesUrl,
                                                               @RequestParam("fields") String[] fields
    );

    /**
     * 工具-转化ID列表
     *
     * @param accessToken  the access token
     * @param advertiserId the advertiser id
     * @param convertIds   the convert ids
     * @param optStatus    the opt status
     * @param page         the page
     * @param pageSize     the page size
     * @return tou tiao resp dto
     */
    @GetMapping(value = "/adv_convert/select/")
    TouTiaoRespDTO<ConvertTargetCallBackDTO> listConvertTarget(@RequestHeader("Access-Token") String accessToken,
                                                               @RequestParam("advertiser_id") Long advertiserId,
                                                               @RequestParam(value = "convert_ids", required = false) Long[] convertIds,
                                                               @RequestParam(value = "opt_status", required = false) String optStatus,
                                                               @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                               @RequestParam(value = "page_size", defaultValue = "10") Integer pageSize
    );


    /**
     * Gets convert target detail.
     *
     * @param accessToken  the access token
     * @param advertiserId the advertiser id
     * @param convertId    the convert id
     * @return the convert target detail
     */
    @GetMapping(value = "/ad_convert/read")
    TouTiaoRespDTO<ConvertTargetDTO> getConvertTargetDetail(@RequestHeader("Access-Token") String accessToken,
                                                            @RequestParam("advertiser_id") Long advertiserId,
                                                            @RequestParam("convert_id") Long convertId
    );
}
