package io.better.toutiao.api.util;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.util.DynamicCreativeWordPackageDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 动态词包Api
 *
 * @author better create in 2019-05-07 10:17
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2/tools", url = "/creative_word")
public interface DynamicCreativeWordPackageApi {

    /**
     * 工具-创建动态创意词包
     *
     * @param accessToken                访问凭证
     * @param dynamicCreativeWordPackage 动态词包信息
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/create")
    TouTiaoRespDTO<Long> createDynamicCreativeWordPackage(@RequestHeader("Access-Token") String accessToken,
                                                          @RequestBody DynamicCreativeWordPackageDTO dynamicCreativeWordPackage
    );


    /**
     * 工具-更新动态创意词包
     *
     * @param accessToken                访问凭证
     * @param dynamicCreativeWordPackage 动态词包信息
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/update")
    TouTiaoRespDTO<Long> updateDynamicCreativeWordPackage(@RequestHeader("Access-Token") String accessToken,
                                                          @RequestBody DynamicCreativeWordPackageDTO dynamicCreativeWordPackage
    );


    /**
     * 工具-删除动态创意词包
     *
     * @param accessToken                访问凭证
     * @param dynamicCreativeWordPackage 动态词包信息
     * @return the tou tiao resp dto
     */
    @PostMapping(value = "/delete")
    TouTiaoRespDTO<Long> deleteDynamicCreativeWordPackage(@RequestHeader("Access-Token") String accessToken,
                                                          @RequestBody DynamicCreativeWordPackageDTO dynamicCreativeWordPackage
    );


    /**
     * 工具-查询动态创意词包
     *
     * @param accessToken     访问凭证
     * @param advertiserId    广告主ID
     * @param creativeWordIds 创意词包ID
     * @return the tou tiao resp dto
     */
    @GetMapping(value = "/select")
    TouTiaoRespDTO<List<DynamicCreativeWordPackageDTO>> listDynamicCreativeWordPackage(@RequestHeader("Access-Token") String accessToken,
                                                                                       @RequestParam("advertiser_id") Long advertiserId,
                                                                                       @RequestParam(value = "creative_word_ids", required = false) Long[] creativeWordIds
    );
}
