package io.better.toutiao.api.util;

import io.better.toutiao.dto.TouTiaoRespDTO;
import io.better.toutiao.dto.util.FileInfoDTO;
import io.better.toutiao.dto.util.FileInfoReqDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * The interface File manager api.
 *
 * @author better create in 2019-04-30 10:51
 */
@FeignClient(value = "https://ad.toutiao.com/open_api/2", url = "/file")
public interface FileManagerApi {

    /**
     * 工具-文件管理-上传广告主图片
     *
     * @param accessToken 访问凭证
     * @param fileInfoOut 文件信息
     * @return the base resp dto
     */
    @PostMapping(value = "/image/advertiser")
    TouTiaoRespDTO<FileInfoDTO> uploadAdvertiserImage(@RequestHeader("Access-Token") String accessToken,
                                                      @RequestBody FileInfoReqDTO fileInfoOut);

    /**
     * 工具-文件管理-上传广告图片
     *
     * @param accessToken 访问凭证
     * @param fileInfoOut 文件信息
     * @return the base resp dto
     */
    @PostMapping(value = "/image/ad")
    TouTiaoRespDTO<FileInfoDTO> uploadAdvertisingImage(@RequestHeader("Access-Token") String accessToken,
                                                       @RequestBody FileInfoReqDTO fileInfoOut);

    /**
     * 工具-文件管理-查询图片信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param imageIds     图片ID
     * @return the image info
     */
    @GetMapping(value = "/ad/get")
    TouTiaoRespDTO<FileInfoDTO> getImageInfo(@RequestHeader("Access-Token") String accessToken,
                                             @RequestParam("advertiser_id") Long advertiserId,
                                             @RequestParam("image_ids") String[] imageIds);

    /**
     * 工具-文件管理-查询视频信息
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告主ID
     * @param videoIds     视频ID
     * @return the video info
     */
    @GetMapping(value = "/video/ad/get")
    TouTiaoRespDTO<FileInfoDTO> getVideoInfo(@RequestHeader("Access-Token") String accessToken,
                                             @RequestParam("advertiser_id") Long advertiserId,
                                             @RequestParam("video_ids") String[] videoIds);


    /**
     * 工具-文件管理-获取图片素材
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告中ID
     * @param filtering    过滤条件
     * @param page         当前页
     * @param pageSize     每页记录数
     * @return the image material info
     */
    @GetMapping(value = "/image/get")
    TouTiaoRespDTO<FileInfoDTO> getImageMaterialInfo(@RequestHeader("Access-Token") String accessToken,
                                                     @RequestParam("advertiser_id") Long advertiserId,
                                                     @RequestParam(value = "video_ids", required = false) Map<String, Object> filtering,
                                                     @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                     @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize);

    /**
     * 工具-文件管理-获取视频素材
     *
     * @param accessToken  访问凭证
     * @param advertiserId 广告中ID
     * @param filtering    过滤条件
     * @param page         当前页
     * @param pageSize     每页记录数
     * @return the video material info
     */
    @GetMapping(value = "/video/get")
    TouTiaoRespDTO<FileInfoDTO> getVideoMaterialInfo(@RequestHeader("Access-Token") String accessToken,
                                                     @RequestParam("advertiser_id") Long advertiserId,
                                                     @RequestParam(value = "video_ids", required = false) Map<String, Object> filtering,
                                                     @RequestParam(value = "page", defaultValue = "1", required = false) Integer page,
                                                     @RequestParam(value = "page_size", defaultValue = "20", required = false) Integer pageSize);


}
