package io.better.toutiao.config;

import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import io.better.toutiao.properties.XxlJobProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * The type Xxl job config.
 *
 * @author better create in 2019-04-28 10:27
 */
@Configuration
public class XxlJobConfig {

    /**
     * Xxl job executor xxl job spring executor.
     *
     * @param xxlJobProperties the xxl job properties
     * @return the xxl job spring executor
     */
    @Bean(initMethod = "start", destroyMethod = "destroy")
    @ConditionalOnMissingBean(value = XxlJobSpringExecutor.class)
    public XxlJobSpringExecutor xxlJobExecutor(XxlJobProperties xxlJobProperties) {
        XxlJobSpringExecutor xxlJobExecutor = new XxlJobSpringExecutor();

        xxlJobExecutor.setIp(xxlJobProperties.getIp());
        xxlJobExecutor.setAdminAddresses(xxlJobProperties.getAdminAddresses());
        xxlJobExecutor.setPort(xxlJobProperties.getPort());
        xxlJobExecutor.setLogPath(xxlJobProperties.getLogPath());
        xxlJobExecutor.setAppName(xxlJobProperties.getAppName());
        xxlJobExecutor.setAccessToken(xxlJobProperties.getAccessToken());
        xxlJobExecutor.setLogRetentionDays(xxlJobProperties.getLogRetentionDays());

        return xxlJobExecutor;
    }
}
