package io.better.toutiao.dto;

import lombok.Data;

/**
 * @author better create in 2019-04-29 14:06
 */
@Data
public class TouTiaoRespDTO<T> {

    /**
     * 成功响应码
     */
    private static final int SUCCESS_CODE = 0;

    /**
     * 响应状态码
     */
    private Integer code;

    /**
     * 响应消息
     */
    private String message;

    /**
     * 响应数据
     */
    private T data;

    /**
     * 是否成功
     *
     * @return true: 表示成功，false: 表示失败
     */
    public Boolean isSuccess() {
        return SUCCESS_CODE == code;
    }
}
