package io.better.toutiao.dto.account;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 账号余额信息
 *
 * @author better create in 2019-05-07 16:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AccountBalanceRespDTO extends BaseDTO {

    /**
     * 账户名
     */
    private String name;

    /**
     * 联系邮箱
     */
    private String email;

    /**
     * 账户总余额(单位元)
     */
    private Double balance;

    /**
     * 账户可用总余额(单位元)
     */
    private Double validBalance;

    /**
     * 现金余额(单位元)
     */
    private Double cash;

    /**
     * 现金可用余额(单位元)
     */
    private Double validCash;

    /**
     * 赠款余额(单位元)
     */
    private Double grant;

    /**
     * 赠款可用余额(单位元)
     */
    private Double validGrant;

    /**
     * 返货余额(单位元)，仅支持部分广告主
     */
    private Double returnGoodsAbs;

    /**
     * 返货可用余额(单位元)，仅支持部分广告主
     */
    private Double validReturnGoodsAbs;

    /**
     * 返货支出(单位元)，仅支持部分广告主
     */
    private Double returnGoodsCost;
}
