package io.better.toutiao.dto.account;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 账号资金日流水
 *
 * @author better create in 2019-05-07 16:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AccountDayFundFlowRespDTO extends BaseDTO {

    /**
     * 日期
     */
    private String date;

    /**
     * 日终结余(单位元）
     */
    private Double balance;

    /**
     * 现金支出(单位元)
     */
    private Double cashCost;

    /**
     * 总支出(单位元)
     */
    private Double cost;

    /**
     * 冻结(单位元)
     */
    private Double frozen;

    /**
     * 总存入(单位元)
     */
    private Double income;

    /**
     * 赠款支出(单位元)
     */
    private Double rewardCost;

    /**
     * 返货支出(单位元)
     */
    private Double returnGoodsCost;

    /**
     * 总转入(单位元)
     */
    private Double transferIn;

    /**
     * 总转出(单位元)
     */
    private Double transferOut;
}
