package io.better.toutiao.dto.account;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 账号资金流水明细
 *
 * @author better create in 2019-05-07 17:06
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AccountFundFlowDetailRespDTO extends BaseDTO {

    /**
     * 流水类型
     *
     * @see io.better.toutiao.enums.FlowType
     */
    private String transactionType;

    /**
     * 流水产生时间
     */
    private String createTime;

    /**
     * 交易总金额(单位元)
     */
    private Double amount;

    /**
     * 冻结总金额(单位元)
     */
    private Double frozen;

    /**
     * 现金总金额(单位元)
     */
    private Double cash;

    /**
     * 赠款总金额(单位元）
     */
    private Double grant;

    /**
     * 返货总金额(单位元)
     */
    private Double returnGoods;

    /**
     * 交易流水号
     */
    private Double transactionSeq;

    /**
     * 付款方，即广告主id
     */
    private Long remitter;

    /**
     * 收款方，即广告主id
     */
    private Long payee;

}
