package io.better.toutiao.dto.account;

import lombok.Data;

/**
 * 广告主信息
 *
 * @author better create in 2019-05-07 15:17
 */
@Data
public class AdvertiserInfoReqRespDTO {

    /**
     * 账户ID
     */
    private Long id;
    /**
     * 账户名
     */
    private String name;

    /**
     * 品牌描述,即推广内容
     */
    private String description;

    /**
     * 联系邮箱
     */
    private String email;

    /**
     * 联系人
     */
    private String contacter;

    /**
     * 手机号码
     */
    private String phonenumber;

    /**
     * 角色, 详见【附录-广告主角色】
     */
    private String role;

    /**
     * 状态,详见【附录-广告主状态】
     */
    private String status;

    /**
     * 固定电话
     */
    private String telephone;

    /**
     * 地址
     */
    private String address;

    /**
     * 执照预览地址(链接默认1小时内有效)
     */
    private String licenseUrl;

    /**
     * 执照编号
     */
    private String licenseNo;

    /**
     * 执照省份
     */
    private String licenseProvince;

    /**
     * 执照城市
     */
    private String licenseCity;

    /**
     * 公司名
     */
    private String company;

    /**
     * 经营类别
     */
    private String brand;

    /**
     * 运营区域
     */
    private String promotionArea;

    /**
     * 运营省份
     */
    private String promotionCenterProvince;

    /**
     * 运营城市
     */
    private String promotionCenterCity;

    /**
     * 一级行业名称（新版），可从tools/industry/get/ 接口获取
     */
    private String firstIndustryName;

    /**
     * 二级行业名称（新版），可从tools/industry/get/ 接口获取
     */
    private String secondIndustryName;

    /**
     * 审核拒绝原因
     */
    private String reason;

    /**
     * 账户可用余额(单位元)
     */
    private Double balance;

    // 创建字段和上面结合使用

    /**
     * 密码
     */
    private String password;

    /**
     * 营销中心城市
     */
    private Integer centerCity;

    /**
     * 营销中心省份
     */
    private Integer centerProvince;

    /**
     * 广告主二级行业
     */
    private Long secondIndustryId;


    // 修改公告主返回字段

    /**
     * 此次修改是否触发进入待审状态
     * <p>
     * (1表示进入待审状态,0表示不进入待审状态)
     */
    private Integer needAudit;
}
