package io.better.toutiao.dto.account;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 广告主资质
 *
 * @author better create in 2019-05-07 15:17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AdvertiserQualificationReqRespDTO extends BaseDTO {

    /**
     * 状态
     */
    private Integer status;

    /**
     * 拒绝理由
     */
    private String rejectReason;

    /**
     * 主体资质
     */
    private SubjectQualification subject;

    /**
     * 开户资质列表
     */
    private List<OpenQualification> others;

    /**
     * 推广资质
     */
    private PromotionQualification promotion;

    /**
     * 主题资质信息
     *
     * @author better create in 2019-05-07 15:17
     */
    @Data
    public static class SubjectQualification {

        /**
         * 资质ID
         */
        private Long qualificationId;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 公司类型
         * 1企业，2个人
         */
        private Integer companyType;

        /**
         * 对公验证类型
         * <p>
         * 1企业，2个体工商户，3政府组织机构/事业单位，4港澳台，
         * 5其他机构（如民办机构），6个人，7海外
         */
        private Integer checkType;

        /**
         * 资质类型
         * <p>
         * 1企业营业执照统一社会信用代码， 2企业营业执照注册号，3个体工商户营业执照统一社会信用代码，4个体工商户营业执照注册号，
         * 5事业单位法人证书统一社会信用代码，6统一社会信用代码证书编号，7民办非企业单位登记证书编号， 8组织机构代码证代号，
         * 9商业登记证号码，
         * 10香港公司注册证书编号，11律师事务所执业许可证编号，12社会团体法人登记证书编号，13民办学校办学许可证编号，
         * 14外国（地区）企业常驻代表机构登记证编号， 15其他编号，116身份证号，117护照号，118港澳/台湾居民往来大陆通行证证件号码，
         * 119律师执业证书执业证号
         */
        private Integer qualificationType;

        /**
         * 资质编号
         */
        private String qualificationCode;

        /**
         * 注册国家
         */
        private String registeredNationName;

        /**
         * 注册省份
         */
        private String registeredProvinceName;

        /**
         * 注册省市
         */
        private String registeredCityName;

        /**
         * 是否有有效日期
         */
        private Boolean hasEffectiveDate;

        /**
         * 过期时间，格式yyyy-mm-dd
         */
        private String effectiveDate;

        /**
         * 法人
         */
        private String proprietorName;

        /**
         * 详细地址
         */
        private String address;

        /**
         * 状态
         * <p>
         * 1待审核，2审核中，3审核通过，4审核不通过
         */
        private Integer status;

        /**
         * 拒绝理由
         */
        private String rejectReason;

        /**
         * 资质图片附件id
         */
        private String attachmentId;

        /**
         * 资质图片地址
         */
        private String pictureUrl;
    }

    /**
     * 开户资质
     */
    @Data
    public static class OpenQualification {

        /**
         * 资质id
         */
        private Long qualificationId;

        /**
         * 状态, 1待审核，2审核中，3审核通过，4审核不通过
         */
        private Integer status;

        /**
         * 拒绝理由
         */
        private String rejectReason;

        /**
         * 资质图片附件id
         */
        private String attachmentId;

        /**
         * 资质图片地址
         */
        private String pictureUrl;
    }

    /**
     * 推广资质
     */
    @Data
    public static class PromotionQualification {

        /**
         * 资质id
         */
        private Long qualificationId;

        /**
         * 状态, 1待审核，2审核中，3审核通过，4审核不通过
         */
        private Integer status;

        /**
         * 推广内容
         */
        private String content;

        /**
         * 拒绝理由
         */
        private String rejectReason;

    }
}
