package io.better.toutiao.dto.datareport;

import io.better.toutiao.dto.PageDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

/**
 * @author better create in 2019-04-28 15:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DataReportQueryDTO extends PageDTO {

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

    /**
     * 分组
     */
    private String[] groupBy;

    /**
     * 时间粒度，STAT_TIME_GRANULARITY_DAILY: 每天；STAT_TIME_GRANULARITY_HOURLY: 每小时
     */
    private String timeGranularity;

    /**
     * 过滤字段
     */
    private Map<String, Object> filtering;
}
