package io.better.toutiao.dto.delivery.creative;

import lombok.Data;

import java.util.List;

/**
 * 广告创意详情信息DTO，粒度比较细
 *
 * @author better create in 2019-04-29 11:16
 */
@Data
public class AdvertisingCreativeInfoDTO {

    /**
     * 广告主ID
     */
    private String advertiserId;

    /**
     * 广告计划ID
     */
    private String adId;

    /**
     * 展示监测链接
     */
    private String trackUrl;

    /**
     * 点击监测链接
     */
    private String actionTrackUrl;

    /**
     * 点击监测链接
     */
    private String videoPlayEffectiveTrackUrl;

    /**
     * 视频播放完毕监测链接
     */
    private String videoPlayDoneTrackUrl;

    /**
     * 视频播放监测链接
     */
    private String videoPlayTrackUrl;

    /**
     * 是否关闭评论
     * <p>
     * 允许值: 0, 1
     */
    private Integer isCommentDisable;


    /**
     * 是否关闭视频详情页落地页
     * 允许值: 0, 1
     */
    private Integer closeVideoDetail;

    /**
     * 创意展现方式
     * <p>
     * 允许值: "CREATIVE_DISPLAY_MODE_CTR", "CREATIVE_DISPLAY_MODE_RANDOM"
     */
    private String creativeDisplayMode;


    /**
     * 是否使用优选广告位，0表示不使用优选，1表示使用，
     * <p>
     * 使用优选广告位的时候默认忽略inventory_type字段
     * <p>
     * 默认值: 0
     * <p>
     * 允许值: 0, 1
     */
    private Integer smartInventory;

    /**
     * 场景广告位
     * <p>
     * 使用场景广告位时默认忽略inventory_type字段，与scene_inventory不能同时传
     * <p>
     * 允许值: "VIDEO_SCENE", "FEED_SCENE", "TAIL_SCENE"
     */
    private String sceneInventory;

    /**
     * 是否开启衍生计划，1为开启，0为不开启
     * <p>
     * 默认值: 0
     */
    private String generateDerivedAd;

    /**
     * 创意投放位置
     */
    private String[] inventoryType;

    /**
     * 文章来源
     * <p>
     * 当推广目的为非应用下载或推广目的为应用下载&download_type=EXTERNAL_URL时必填
     */
    private String source;

    /**
     * 应用名
     * <p>
     * 当推广应用下载[包含Android、iOS]时, 必填
     */
    private String appName;

    /**
     * Android应用下载详情页
     * <p>
     * 当推广应用下载Android时, 必填
     */
    private String webUrl;

    /**
     * 创意标签
     * <p>
     * 以英文逗号分隔,最多20个标签,且每个标签长度不超过10个字符
     */
    private String[] adKeywords;

    /**
     * 创意分类-三级行业（新版），填写三级行业ID，
     * <p>
     * 可从tools/industry/get/ 接口获取
     */
    private Integer thirdIndustryId;

    /**
     * 附加创意类型
     * 仅当推广目的landing_type=LINK时,填写
     * 允许值: "ATTACHED_CREATIVE_NONE", "ATTACHED_CREATIVE_PHONE","ATTACHED_CREATIVE_FORM"
     */
    private String advancedCreativeType;

    /**
     * 附加创意标题
     */
    private String advancedCreativeTitle;

    /**
     * 电话号码
     * 当附加创意类型为ATTACHED_CREATIVE_PHONE时, 必填
     */
    private String phoneNumber;

    /**
     * 按钮文本
     * 当附加创意类型不为ATTACHED_CREATIVE_NONE时, 必填
     */
    private String buttonText;

    /**
     * 表单提交链接
     * 当附加创意类型为ATTACHED_CREATIVE_FORM时, 必填
     * 且当附加创意类型为当附加创意类型为ATTACHED_CREATIVE_FORM时, 必须为今日头条建站地址
     */
    private String formUrl;

    /**
     * 创意类型
     * 该字段为STATIC_ASSEMBLE表示程序化创意，其他情况无该字段
     */
    private String creativeMaterialMode;

    /**
     * 标题信息，程序化创意必填
     */
    private List<TitleInfo> titleList;

    /**
     * 素材信息，程序化创意必填
     */
    private List<ImageInfo> imageList;

    /**
     * 素材信息，投放位置和创意类型决定素材规格
     *
     * @see MaterialInfo
     */
    private List<MaterialInfo> creatives;

    /**
     * 修改时间
     */
    private String modifyTime;
}
