package io.better.toutiao.dto.delivery.creative;

import lombok.Data;

import java.util.List;

/**
 * 广告创意列表信息DTO，粒度不够细
 *
 * @author better create in 2019-04-29 11:16
 */
@Data
public class AdvertisingCreativeListInfoDTO {
    /**
     * 创意ID
     */
    private String creativeId;

    /**
     * 广告计划ID
     */
    private String adId;

    /**
     * 广告主ID
     */
    private String advertiserId;

    /**
     * 创意素材标题
     */
    private String title;

    /**
     * 动态词包列表
     */
    private String[] creativeWordIds;

    /**
     * 创意素材状态
     */
    private String status;

    /**
     * 创意素材操作状态
     */
    private String optStatus;

    /**
     * 创意素材类型
     */
    private String imageMode;

    /**
     * 图片素材id列表
     */
    private String[] imageIds;

    /**
     * 视频素材封面
     */
    private String imageId;

    /**
     * 视频id
     */
    private String videoId;

    /**
     * 第三方id
     */
    private String thirdPartyId;

    /**
     * 创意审核信息
     */
    private String auditRejectReason;

    /**
     * 素材信息列表
     */
    private List<MaterialInfo> materials;
}