package io.better.toutiao.dto.delivery.creative;

import lombok.Data;

import java.util.List;

/**
 * 素材信息
 * <p>
 * 包含图片素材字段和视频素材字段
 *
 * @author better create in 2019-04-30 09:50
 */
@Data
public class MaterialInfo extends ImageInfo {

    /**
     * 创意ID
     */
    private Long creativeId;

    /**
     * 创意标题，如果要使用动态词包
     * 格式如下：“XXX{词包名}XXX{词包名}XXX”
     * 请注意当您使用动态词包需在下方creative_word_ids字段中按顺序传入词包ID
     * 并且在一个标题中最多使用两个动态词包。长度为6-30个字, 两个英文字符占1位
     */
    private String title;

    /**
     * 动态词包ID，可使用动态词包查询接口获得
     * 结合标题中的词包格式您需要填写相同个数与顺序的词包ID
     * 如果实际ID顺序与标题中词包名顺序不一致我们将以词包ID顺序为准
     */
    private List<?> creativeWordIds;


    /**
     * 创意自定义参数，
     * 例如开发者可设定此参数为创意打标签用于区分使用的素材类型，选填
     */
    private String thirdPartyId;
}
