package io.better.toutiao.dto.delivery.plan;

import io.better.toutiao.dto.PageDTO;
import lombok.Data;

import java.util.List;

/**
 * @author better create in 2019-05-07 18:33
 */
@Data
public class AdPlanRespDTO {

    /**
     * 广告计划ID，接收创建、更新返回参数
     */
    private Long adId;

    /**
     * 此次修改是否触发进入待审状态，接收更新返回参数
     * (1表示进入待审状态,0表示不进入待审状态)
     */
    private Integer needAudit;

    /**
     * 广告计划ID集合, 接收更新计划状态返回参数
     */
    private List<Long> adIds;

    /**
     * 广告计划信息计划， 接收查询返回参数
     */
    private List<AdvertisingPlanInfoDTO> list;

    /**
     * 分页信息，接收查询返回参数
     */
    private PageDTO pageInfo;
}
