package io.better.toutiao.dto.delivery.plan;

import lombok.Data;

/**
 * 广告受众相关信息
 *
 * @author better create in 2019-04-29 15:26
 */
@Data
public class AudienceInfoDTO {

    /**
     * 定向人群包列表，内容为人群包id.(新增字段，使用新增字段支持同时选择定向和排除)
     */
    private Integer[] retargetingTagsInclude;

    /**
     * 排除人群包列表，内容为人群包id.(新增字段，使用新增字段支持同时选择定向和排除)
     */
    private Integer[] retargetingTagsExclude;

    /**
     * 受众性别
     *
     * @see io.better.toutiao.enums.common.Gender
     */
    private String gender;

    /**
     * 受众年龄区间
     *
     * @see io.better.toutiao.enums.common.Age
     */
    private String[] age;

    /**
     * 受众最低android版本
     *
     * @see io.better.toutiao.enums.common.AndroidOsv
     */
    private String androidOsv;

    /**
     * 受众最低ios版本
     *
     * @see io.better.toutiao.enums.common.IosOsv
     */
    private String iosOsv;

    /**
     * 受众网络类型
     *
     * @see io.better.toutiao.enums.common.Ac
     */
    private String[] ac;

    /**
     * 受众手机品牌
     *
     * @see io.better.toutiao.enums.common.DeviceBrand
     */
    private String[] deviceBrand;

    /**
     * 受众文章分类
     *
     * @see io.better.toutiao.enums.audience.ArticleCategory
     */
    private String[] articleCategory;

    /**
     * 用户首次激活时间
     *
     * @see io.better.toutiao.enums.UserFirstActiveTime
     */
    private String[] activateType;

    /**
     * 受众平台
     *
     * @see io.better.toutiao.enums.common.Platform
     */
    private String[] platform;

    /**
     * 受众运营商
     *
     * @see io.better.toutiao.enums.audience.Carrier
     */
    private String[] carrier;

    /**
     * 兴趣分类,如果传空数组 [] 表示不限，如果只传[0]表示系统推荐,如果按兴趣类型传表示自定义
     */
    private Integer[] adTag;

    /**
     * 兴趣关键词, 返回值为词id，非兴趣词包id，可通过兴趣词包接口id2word获取具体词
     */
    private Integer[] interestTags;

    /**
     * 地域类型，前者为省市，后者为区县。当city有数据时，必填。
     * 允许值: "CITY", "COUNTY" , "BUSINESS_DISTRICT","NONE"
     */
    private String district;

    /**
     * 地域定向城市列表(当传递省份ID时,旗下市县ID可省略不传)
     */
    private Integer[] city;

    /**
     * 受众位置类型
     *
     * @see io.better.toutiao.enums.audience.LocationType
     */
    private String locationType;

    /**
     * 商圈ID数组
     */
    private Integer[] businessIds;

    /**
     * APP行为定向, (请注意如果投放的是应用下载-IOS不支持设置APP行为定向，请勿传值)
     */
    private String appBehaviorTarget;

    /**
     * APP行为定向,分类集合,(请注意如果投放的是应用下载-IOS不支持设置APP行为定向，请勿传值)
     */
    private Integer[] appCategory;

    /**
     * APP行为定向,APP集合(请注意如果投放的是应用下载-IOS不支持设置APP行为定向，请勿传值)
     */
    private Integer[] appIds;

    /**
     * 产品目录ID(ID由查询产品目录接口得到), 当推广目的landing_type=DPA时存在
     */
    private Integer productPlatformId;

    /**
     * dpa广告类型
     * 取值范围：DPA_LINK（dpa落地页）DPA_APP（dpa应用下载）
     */
    private String[] dpaAdType;


    /**
     * DPA落地页类型广告落地页链接
     */
    private String[] dpaExternalUrls;

    /**
     * DPA直达链接
     */
    private String[] dpaOpenUrls;


    /**
     * DPA投放范围
     * 取值范围：NONE（不限）CATEGORY（指定类别）PRODUCT（指定商品）
     */
    private String[] dpaCategoryType;


    /**
     * dpa_category_type取值范围为CATEGORY时必填，表示类别
     */
    private Integer[] dpaCategories;


    /**
     * dpa_category_type为PRODUCT时必填，表示商品列表
     */
    private Integer[] dpaProducts;

    /**
     * H5地址参数(DPA推广目的特有,在填写的参数后面添加"=urlencode(开放平台提供的h5链接地址）"，
     * 其中urlencode(开放平台提供的h5链接地址）替换为商品库中的h5地址encode的结果)
     */
    private String externalUrlParams;


    /**
     * DPA直达链接参数(DPA推广目的特有,在“产品库中提取的scheme地址"后面追加填写的参数)
     */
    private String openUrlParams;

    /**
     * DPA人群定向(DPA推广目的特有)
     * 取值范围：NONE（不限）CUSTOM（自定义）
     */
    private Integer dpaLocalAudience;


    /**
     * 包含人群包,格式为Json字符串
     */
    private String[] includeCustomActions;

    /**
     * 排除人群包,格式为Json字符串
     */
    private String[] excludeCustomActions;

    /**
     * 穿山甲视频创意类型
     * 默认值: ORIGINAL_VIDEO
     * <p>
     * 允许值: "ORIGINAL_VIDEO", "REWARDED_VIDEO"
     */
    private String unionVideoType;


    /**
     * 精选流量包
     *
     * @see io.better.toutiao.enums.audience.SuperiorPopularityType
     */
    private String superiorPopularityType;


    /**
     * 定向流量包ID数组
     */
    private Integer[] flowPackage;

    /**
     * 排除流量包ID数组
     */
    private Integer[] excludeFlowPackage;

    /**
     * 深度优化方式
     */
    private String deepBidType;

    /**
     * 深度优化出价
     */
    private Integer deepCpabid;

    /**
     * 创意投放位置
     */
    private String[] inventoryType;

}
