package io.better.toutiao.dto.delivery.plan;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 计划出价
 *
 * @author better create in 2019-05-07 20:03
 */
@Data
public class PlanBidDTO {

    /**
     * 出价
     */
    private Integer bid;

    /**
     * 计划ID
     */
    private Integer adId;

    /**
     * 更新计划出价DTO
     */
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class UpdateBidDTO extends PlanBidDTO {

        /**
         * 广告主ID
         */
        private Long advertiserId;

        /**
         * 计划ID集合
         */
        private List<Integer> adIds;

        /**
         * ID集合
         */
        private List<PlanBidDTO> data;
    }

}
