package io.better.toutiao.dto.delivery.plan;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 计划预算
 *
 * @author better create in 2019-04-29 14:48
 */
@Data
public class PlanBudgetDTO {

    /**
     * 计划ID
     */
    private Integer adId;

    /**
     * 预算
     */
    private Integer budget;

    /**
     * 更新计划预算DTO
     */
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class UpdateBudgetDTO extends PlanBudgetDTO {

        /**
         * 广告主ID
         */
        private Long advertiserId;

        /**
         * ID集合
         */
        private List<PlanBudgetDTO> data;
    }
}