package io.better.toutiao.dto.util;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 转换目标信息
 *
 * @author better create in 2019-05-07 10:43
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ConvertTargetDTO extends ConvertTargetStatusDTO {

    /**
     * 转化名称
     */
    private String name;

    /**
     * 转化来源，详见【附录-转化工具来源】，默认为AD_CONVERT_SOURCE_TYPE_APP_DOWNLOAD
     */
    private String convertSourceType;

    /**
     * 下载链接
     */
    private String downloadUrl;

    /**
     * 应用类型
     * 允许值: "APP_ANDROID", "APP_IOS"
     */
    private String appType;

    /**
     * 转化监测链接
     */
    private String actionTrackUrl;

    /**
     * 包名
     */
    private String packageName;

    /**
     * 转化类型，详见【附录-转化类型】
     */
    private String convertType;

    /**
     * XPath转化路径
     */
    private String convertXpathValue;

    /**
     * XPath转化页面地址
     */
    private String convertXpathUrl;

    /**
     * 落地页地址
     */
    private String externalUrl;

    /**
     * APP ID
     */
    private String appId;

    /**
     * 直达链接
     */
    private String openUrl;

    /**
     * 深度转化目标
     */
    private String deepExternalAction;


}
