package io.better.toutiao.dto.util;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author better create in 2019-05-07 10:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DynamicCreativeWordPackageDTO extends BaseDTO {

    /**
     * 创意词包名称
     */
    private String name;

    /**
     * 默认词
     */
    private String defaultWord;

    /**
     * 替换词
     */
    private String[] words;

    /**
     * 创意词包id，删除、更新时使用
     */
    private Long creativeWordId;

    /**
     * 创意词包类型, 查询使用
     */
    private String contentType;

    /**
     * 替换词最大长度, 查询使用
     */
    private Integer maxWordLen;

    /**
     * 创意词包状态, 查询使用
     */
    private String status;

    /**
     * 创意词包人群覆盖率, 查询使用
     * <p>
     * 取值范围: 0-1
     */
    private Float rate;
}
