package io.better.toutiao.dto.util;

import io.better.toutiao.dto.BaseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.File;

/**
 * @author better create in 2019-04-30 10:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FileInfoReqDTO extends BaseDTO {

    // ==========图片信息==========

    /**
     * 图片上传方式
     * 默认值: UPLOAD_BY_FILE
     * 允许值: "UPLOAD_BY_FILE", "UPLOAD_BY_URL"
     */
    private String uploadType;

    /**
     * 图片的md5
     */
    private String imageSignature;

    /**
     * 图片地址
     * upload_type为UPLOAD_BY_FILE必填
     */
    private File imageFile;

    /**
     * 图片地址url
     * upload_type为UPLOAD_BY_URL必填
     */
    private String imageUrl;

    // ==========图片信息 end============

    // ==========视频信息 start==========

    /**
     * 视频MD5
     */
    private String videoSignature;

    /**
     * 视频文件
     */
    private File videoFile;

    // ==========视频信息 end============
}
