package io.better.toutiao.enums;

import lombok.Getter;

/**
 * 广告计划出价类型
 *
 * @author better create in 2019-04-29 15:07
 */
@Getter
public enum AdvertisingPlanBidType {

    /**
     * 出价范围（单位元）:0.2-100，日预算范围（单位元）：大于100，总预算范围：大于最低日预算乘投放天数
     */
    PRICING_CPC,

    /**
     * 出价范围（单位元）: 4-100，日预算范围（单位元）：大于100，总预算范围：大于最低日预算乘投放天数
     */
    PRICING_CPM,


    /**
     * 出价范围（单位元）:4-1000，日预算范围（单位元）：大于300，总预算范围：大于最低日预算乘投放天数
     */
    PRICING_OCPM,

    /**
     * 出价范围（单位元）:0.07-100，日预算范围（单位元）：大于100，
     * 总预算范围：大于最低日预算乘投放天数（CPV广告只支持投放到头条系广告位，不支持投放到视频信息流如西瓜、火山、抖音）
     */
    PRICING_CPV,

    /**
     * API暂不支持CPA计划创建和修改
     */
    PRICING_CPA
}
