package io.better.toutiao.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 广告主角色枚举
 *
 * @author better create in 2019-05-06 14:19
 */
@Getter
@AllArgsConstructor
public enum AdvertisingRole {

    /**
     * 普通广告主（直客）
     */
    ROLE_ADVERTISER("ROLE_ADVERTISER"),

    /**
     * 普通广告主（代理商子客户）
     */
    ROLE_CHILD_ADVERTISER("ROLE_CHILD_ADVERTISER"),

    /**
     * 二级代理商
     */
    ROLE_CHILD_AGENT("ROLE_CHILD_AGENT"),

    /**
     * 一级代理商
     */
    ROLE_AGENT("ROLE_AGENT");

    /**
     * 角色
     */
    private String role;
}
