package io.better.toutiao.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 广告主状态
 *
 * @author better create in 2019-05-06 14:23
 */
@Getter
@AllArgsConstructor
public enum AdvertisingStatus {

    /**
     * 已禁用
     */
    STATUS_DISABLE("STATUS_DISABLE"),

    /**
     * 申请待审核
     */
    STATUS_PENDING_CONFIRM("STATUS_PENDING_CONFIRM"),

    /**
     * 待验证
     */
    STATUS_PENDING_VERIFIED("STATUS_PENDING_VERIFIED"),

    /**
     * 审核不通过
     */
    STATUS_CONFIRM_FAIL("STATUS_CONFIRM_FAIL"),

    /**
     * 已审核
     */
    STATUS_ENABLE("STATUS_ENABLE"),

    /**
     * CRM审核不通过
     */
    STATUS_CONFIRM_FAIL_END("STATUS_CONFIRM_FAIL_END"),

    /**
     * 修改待审核
     */
    STATUS_PENDING_CONFIRM_MODIFY("STATUS_PENDING_CONFIRM_MODIFY"),

    /**
     * 修改审核不通过
     */
    STATUS_CONFIRM_MODIFY_FAIL("STATUS_CONFIRM_MODIFY_FAIL"),

    /**
     * 限制
     */
    STATUS_LIMIT("STATUS_LIMIT"),

    /**
     * 等待CRM审核
     */
    STATUS_WAIT_FOR_BPM_AUDIT("STATUS_WAIT_FOR_BPM_AUDIT"),

    /**
     * 待对公验证
     */
    STATUS_WAIT_FOR_PUBLIC_AUTH("STATUS_WAIT_FOR_PUBLIC_AUTH");


    /**
     * 状态
     */
    private String status;
}
