package io.better.toutiao.enums.creative;

import lombok.Getter;

/**
 * 创意状态
 *
 * @author better create in 2019-05-06 18:00
 */
@Getter
public enum CreativeStatus {

    /**
     * 投放中
     */
    CREATIVE_STATUS_DELIVERY_OK,

    /**
     * 未到达投放时间
     */
    CREATIVE_STATUS_NOT_START,

    /**
     * 不在投放时段
     */
    CREATIVE_STATUS_NO_SCHEDULE,

    /**
     * 创意暂停
     */
    CREATIVE_STATUS_DISABLE,

    /**
     * 已被广告组暂停
     */
    CREATIVE_STATUS_CAMPAIGN_DISABLE,

    /**
     * 广告组超出预算
     */
    CREATIVE_STATUS_CAMPAIGN_EXCEED,

    /**
     * 新建审核中
     */
    CREATIVE_STATUS_AUDIT,

    /**
     * 修改审核中
     */
    CREATIVE_STATUS_REAUDIT,

    /**
     * 已删除
     */
    CREATIVE_STATUS_DELETE,

    /**
     * 已完成（投放达到结束时间）
     */
    CREATIVE_STATUS_DONE,

    /**
     * 广告计划暂停
     */
    CREATIVE_STATUS_AD_DISABLE,

    /**
     * 审核不通过
     */
    CREATIVE_STATUS_AUDIT_DENY,

    /**
     * 账户余额不足
     */
    CREATIVE_STATUS_BALANCE_EXCEED,

    /**
     * 超出预算
     */
    CREATIVE_STATUS_BUDGET_EXCEED,

    /**
     * 数据错误（数据错误时返回，极少出现）
     */
    CREATIVE_STATUS_DATA_ERROR,

    /**
     * 预上线
     */
    CREATIVE_STATUS_PRE_ONLINE,

    /**
     * 广告计划新建审核中
     */
    CREATIVE_STATUS_AD_AUDIT,

    /**
     * 广告计划修改审核中
     */
    CREATIVE_STATUS_AD_REAUDIT,

    /**
     * 广告计划审核不通过
     */
    CREATIVE_STATUS_AD_AUDIT_DENY,

    /**
     * 所有包含已删除
     */
    CREATIVE_STATUS_ALL,

    /**
     * 所有不包含已删除（状态过滤默认值）
     */
    CREATIVE_STATUS_NOT_DELETE,

    /**
     * 超出账户日预算
     */
    CREATIVE_STATUS_ADVERTISER_BUDGET_EXCEED
}
