package io.better.toutiao.excel;

import java.util.List;

/**
 * excel处理接口
 *
 * @param <T> 写入数据类型
 * @author better create in 2019-04-28 15:31
 */
public interface ExcelHandle<T> {

    /**
     * 生成excel
     *
     * @param fileName  excel名称
     * @param outPath   输出路径
     * @param writeData 写入数据
     */
    void generateExcel(String fileName, String outPath, List<T> writeData);

    /**
     * 获取文件名
     *
     * @return 文件名
     */
    String getFileName();

    /**
     * 生成文件名
     *
     * @return 文件名
     */
    String generateFileName();
}
