package io.better.toutiao.job.oauth;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import io.better.toutiao.api.oauth2.OAuth2Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author better create in 2019-04-28 10:26
 */
@Component
@JobHandler(value = "AccessTokenRefreshXxlJob")
@Slf4j
public class AccessTokenRefreshXxlJob extends IJobHandler {

    private OAuth2Api oAuth2Api;

    @Autowired
    public AccessTokenRefreshXxlJob(OAuth2Api oAuth2Api) {
        this.oAuth2Api = oAuth2Api;
    }

    @Override
    public ReturnT<String> execute(String param) throws Exception {
        log.info("AccessTokenRefreshXxlJob is execute and param => {}", param);
        oAuth2Api.refreshToken(null);
        return ReturnT.SUCCESS;
    }
}
