package io.better.toutiao.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author better create in 2019-04-28 10:27
 */
@ConfigurationProperties(prefix = "xxl.job")
@Component
@Data
public class XxlJobProperties {

    /**
     * xxl-job地址
     */
    private String adminAddresses;

    /**
     * IP地址
     */
    private String ip;

    /**
     * 日志名称
     */
    private String appName;

    /**
     * 日志地址
     */
    private String logPath;

    /**
     * 端口号
     */
    private Integer port;

    /**
     * 凭证
     */
    private String accessToken;

    /**
     * 日志保存时长
     */
    private Integer logRetentionDays;
}
