package io.better.toutiao.service.datareport;

import io.better.toutiao.dto.datareport.DataReportQueryDTO;

import java.util.List;

/**
 * The interface Data report service.
 *
 * @author better create in 2019-04-28 15:54
 */
public interface DataReportService {

    /**
     * 获取广告主报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertisers report data
     */
    List<Object> getAdvertisersReportData(DataReportQueryDTO dataReportQueryDTO);

    /**
     * 获取某广告主的广告组报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising group report data
     */
    List<Object> getAdvertisingGroupReportData(DataReportQueryDTO dataReportQueryDTO);

    /**
     * 获取某广告主的广告计划报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising plan report data
     */
    List<Object> getAdvertisingPlanReportData(DataReportQueryDTO dataReportQueryDTO);

    /**
     * 获取某广告主的广告创意报表信息
     *
     * @param dataReportQueryDTO the data report dto
     * @return the advertising creative report data
     */
    List<Object> getAdvertisingCreativeReportData(DataReportQueryDTO dataReportQueryDTO);
}
