//
// Created by Fear1ess on 2021/4/1.
//

#include "jni_helper.h"

void wdCheckException(JNIEnv* env) {
    if(env->ExceptionOccurred() != nullptr){
        env->ExceptionDescribe();
        env->ExceptionClear();
    }
}

char wdGetMethodRetType(const char* sig) {
    char* p = (char*)sig;
    // skip '()' to find out the return type
    while (*p != ')'){
        p++;
    }
    // skip ')'
    p++;
    return *p;
}

jvalue wdGetStaticField(JNIEnv* env, const char* clsName, const char* fieldName, const char* fieldSig) {
    jclass cls = env->FindClass(clsName);
    jfieldID fieldId = env->GetStaticFieldID(cls, fieldName, fieldSig);
    jvalue value = {0};
    switch(wdGetFieldType(fieldSig)) {
        case '[':
        case 'L':
            value.l = env->GetStaticObjectField(cls, fieldId);
            break;
        case 'Z':
            value.z = env->GetStaticBooleanField(cls, fieldId);
            break;
        case 'B':
            value.b = env->GetStaticByteField(cls, fieldId);
            break;
        case 'C':
            value.c = env->GetStaticCharField(cls, fieldId);
            break;
        case 'S':
            value.s = env->GetStaticShortField(cls, fieldId);
            break;
        case 'I':
            value.i = env->GetStaticIntField(cls, fieldId);
            break;
        case 'J':
            value.j = env->GetStaticLongField(cls, fieldId);
            break;
        case 'F':
            value.f = env->GetStaticFloatField(cls, fieldId);
            break;
        case 'D':
            value.d = env->GetStaticDoubleField(cls, fieldId);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
    return value;
}

jvalue wdGetField(JNIEnv* env, jobject obj, const char* fieldName, const char* fieldSig) {
    jclass cls = env->GetObjectClass(obj);
    jfieldID fieldId = env->GetFieldID(cls, fieldName, fieldSig);
    jvalue value = {0};
    switch(wdGetFieldType(fieldSig)) {
        case '[':
        case 'L':
            value.l = env->GetObjectField(cls, fieldId);
            break;
        case 'Z':
            value.z = env->GetBooleanField(cls, fieldId);
            break;
        case 'B':
            value.b = env->GetByteField(cls, fieldId);
            break;
        case 'C':
            value.c = env->GetCharField(cls, fieldId);
            break;
        case 'S':
            value.s = env->GetShortField(cls, fieldId);
            break;
        case 'I':
            value.i = env->GetIntField(cls, fieldId);
            break;
        case 'J':
            value.j = env->GetLongField(cls, fieldId);
            break;
        case 'F':
            value.f = env->GetFloatField(cls, fieldId);
            break;
        case 'D':
            value.d = env->GetDoubleField(cls, fieldId);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
    return value;
}

void wdSetStaticField(JNIEnv* env, const char* clsName, const char* fieldName, const char* fieldSig, jvalue value) {
    jclass cls = env->FindClass(clsName);
    jfieldID fieldId = env->GetStaticFieldID(cls, fieldName, fieldSig);
    switch(wdGetFieldType(fieldSig)) {
        case '[':
        case 'L':
            env->SetStaticObjectField(cls, fieldId, value.l);
            break;
        case 'Z':
            env->SetStaticBooleanField(cls, fieldId, value.z);
            break;
        case 'B':
            env->SetStaticByteField(cls, fieldId, value.b);
            break;
        case 'C':
            env->SetStaticCharField(cls, fieldId, value.c);
            break;
        case 'S':
            env->SetStaticShortField(cls, fieldId, value.s);
            break;
        case 'I':
            env->SetStaticIntField(cls, fieldId, value.i);
            break;
        case 'J':
            env->SetStaticLongField(cls, fieldId, value.j);
            break;
        case 'F':
            env->SetStaticFloatField(cls, fieldId, value.f);
            break;
        case 'D':
            env->SetStaticDoubleField(cls, fieldId, value.d);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
}

void wdSetField(JNIEnv* env, jobject obj, const char* fieldName, const char* fieldSig, jvalue value) {
    jclass cls = env->GetObjectClass(cls);
    jfieldID fieldId = env->GetFieldID(cls, fieldName, fieldSig);
    switch(wdGetFieldType(fieldSig)) {
        case '[':
        case 'L':
            env->SetObjectField(obj, fieldId, value.l);
            break;
        case 'Z':
            env->SetBooleanField(cls, fieldId, value.z);
            break;
        case 'B':
            env->SetByteField(cls, fieldId, value.b);
            break;
        case 'C':
            env->SetCharField(cls, fieldId, value.c);
            break;
        case 'S':
            env->SetShortField(cls, fieldId, value.s);
            break;
        case 'I':
            env->SetIntField(cls, fieldId, value.i);
            break;
        case 'J':
            env->SetLongField(cls, fieldId, value.j);
            break;
        case 'F':
            env->SetFloatField(cls, fieldId, value.f);
            break;
        case 'D':
            env->SetDoubleField(cls, fieldId, value.d);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
}

jobject wdNewObject(JNIEnv* env, const char* clsName, const char* methodSig, ...) {
    jclass cls = env->FindClass(clsName);
    jmethodID methodId = env->GetMethodID(cls, "<init>", methodSig);
    va_list args;
    va_start(args, methodSig);
    jobject res = nullptr;
    res = env->NewObjectV(cls, methodId, args);
    wdCheckException(env);
    va_end(args);
    env->DeleteLocalRef(cls);
    return res;
}

jvalue wdCallStaticMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, va_list args) {
    jclass cls = env->FindClass(clsName);
    jmethodID methodId = env->GetStaticMethodID(cls, methodName, methodSig);
    jvalue value = {0};
    switch(wdGetMethodRetType(methodSig)) {
        case 'V':
            env->CallStaticVoidMethodV(cls, methodId, args);
            break;
        case '[':
        case 'L':
            value.l = env->CallStaticObjectMethodV (cls, methodId, args);
            break;
        case 'Z':
            value.z = env->CallStaticBooleanMethodV(cls, methodId, args);
            break;
        case 'B':
            value.b = env->CallStaticByteMethodV(cls, methodId, args);
            break;
        case 'C':
            value.c = env->CallStaticCharMethodV(cls, methodId, args);
            break;
        case 'S':
            value.s = env->CallStaticShortMethodV(cls, methodId, args);
            break;
        case 'I':
            value.i = env->CallStaticIntMethodV(cls, methodId, args);
            break;
        case 'J':
            value.j = env->CallStaticLongMethodV(cls, methodId, args);
            break;
        case 'F':
            value.f = env->CallStaticFloatMethodV(cls, methodId, args);
            break;
        case 'D':
            value.d = env->CallStaticDoubleMethodV(cls, methodId, args);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
    return value;
}

jvalue wdCallMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, va_list args) {
    jclass cls = env->GetObjectClass(obj);
    jmethodID methodId = env->GetMethodID(cls, methodName, methodSig);
    jvalue value = {0};
    switch(wdGetMethodRetType(methodSig)) {
        case 'V':
            env->CallVoidMethodV(obj, methodId, args);
            break;
        case '[':
        case 'L':
            value.l = env->CallObjectMethodV (obj, methodId, args);
            break;
        case 'Z':
            value.z = env->CallBooleanMethodV(obj, methodId, args);
            break;
        case 'B':
            value.b = env->CallByteMethodV(obj, methodId, args);
            break;
        case 'C':
            value.c = env->CallCharMethodV(obj, methodId, args);
            break;
        case 'S':
            value.s = env->CallShortMethodV(obj, methodId, args);
            break;
        case 'I':
            value.i = env->CallIntMethodV(obj, methodId, args);
            break;
        case 'J':
            value.j = env->CallLongMethodV(obj, methodId, args);
            break;
        case 'F':
            value.f = env->CallFloatMethodV(obj, methodId, args);
            break;
        case 'D':
            value.d = env->CallDoubleMethodV(obj, methodId, args);
            break;
        default: break;
    }
    wdCheckException(env);
    env->DeleteLocalRef(cls);
    return value;
}

jboolean wdCallStaticBooleanMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jboolean res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).z;
    va_end(args);
    return res;
}

jbyte wdCallStaticByteMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jboolean res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).b;
    va_end(args);
    return res;
}

jchar wdCallStaticCharMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jchar res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).c;
    va_end(args);
    return res;
}

jshort wdCallStaticShortMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jshort res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).s;
    va_end(args);
    return res;
}

jint wdCallStaticIntMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jint res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).i;
    va_end(args);
    return res;
}

jlong wdCallStaticLongMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jlong res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).j;
    va_end(args);
    return res;
}

jfloat wdCallStaticFloatMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jfloat res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).f;
    va_end(args);
    return res;
}

jdouble wdCallStaticDoubleMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jdouble res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).d;
    va_end(args);
    return res;
}

jobject wdCallStaticObjectMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jobject res = wdCallStaticMethod(env, clsName, methodName, methodSig, args).l;
    va_end(args);
    return res;
}

void wdCallStaticVoidMethod(JNIEnv* env, const char* clsName, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    wdCallStaticMethod(env, clsName, methodName, methodSig, args);
    va_end(args);
}


jboolean wdCallBooleanMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jboolean res = wdCallMethod(env, obj, methodName, methodSig, args).z;
    va_end(args);
    return res;
}

jbyte wdCallByteMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jboolean res = wdCallMethod(env, obj, methodName, methodSig, args).b;
    va_end(args);
    return res;
}

jchar wdCallCharMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jchar res = wdCallMethod(env, obj, methodName, methodSig, args).c;
    va_end(args);
    return res;
}

jshort wdCallShortMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jshort res = wdCallMethod(env, obj, methodName, methodSig, args).s;
    va_end(args);
    return res;
}

jint wdCallIntMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jint res = wdCallMethod(env, obj, methodName, methodSig, args).i;
    va_end(args);
    return res;
}

jlong wdCallLongMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jlong res = wdCallMethod(env, obj, methodName, methodSig, args).j;
    va_end(args);
    return res;
}

jfloat wdCallFloatMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jfloat res = wdCallMethod(env, obj, methodName, methodSig, args).f;
    va_end(args);
    return res;
}

jdouble wdCallDoubleMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jdouble res = wdCallMethod(env, obj, methodName, methodSig, args).d;
    va_end(args);
    return res;
}

jobject wdCallObjectMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    jobject res = wdCallMethod(env, obj, methodName, methodSig, args).l;
    va_end(args);
    return res;
}

void wdCallVoidMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...) {
    va_list args;
    va_start(args, methodSig);
    wdCallMethod(env, obj, methodName, methodSig, args);
    va_end(args);
}







